<?php

declare(strict_types=1);

namespace Drupal\schema_form_test\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\schema_form\SchemaFormBase;

/**
 * Example sub-form class for testing schema-based form generation.
 */
class MyChildForm extends SchemaFormBase {

  /**
   * {@inheritdoc}
   */
  public function getSchemaFormSchema(): string|null {
    return 'schema_form_test.my_child_form';
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->messenger()->addMessage($this->t('Form submitted successfully.'));
  }

}
