<?php

declare(strict_types=1);

namespace Drupal\schema_form_test\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\TypedData\TraversableTypedDataInterface;
use Drupal\schema_form\SchemaFormBase;

/**
 * Test implementation of a schema-based feedback form.
 *
 * This class demonstrates using SchemaFormBase to create a simple feedback form
 * from the schema_form_test.my_feedback_form schema definition. It shows the
 * minimal implementation required for a working schema-based form.
 *
 * @see \Drupal\schema_form\SchemaFormBase
 */
class MyFeedbackForm extends SchemaFormBase {

  /**
   * {@inheritdoc}
   */
  public function getSchemaFormSchema(): string|null {
    return 'schema_form_test.my_feedback_form';
  }

  /**
   * {@inheritdoc}
   */
  // phpcs:ignore Generic.CodeAnalysis.UselessOverridingMethod.Found
  public function validateForm(array &$form, FormStateInterface $form_state): void {
    // Base validation according to constraints is done in the parent function.
    // But here the custom validation logic can be added.
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function processSubmittedValues(TraversableTypedDataInterface $values, FormStateInterface $form_state): void {
    // Custom handling of already validated form submission typed values.
    $valuesArray = $values->getValue();
    $name = $valuesArray['first_name'] ?? NULL;
    $this->messenger()->addMessage($this->t('Thank you, @name!', [
      '@name' => $name ?? $this->t('Anonymous'),
    ]));
  }

}
