<?php

declare(strict_types=1);

namespace Drupal\schema_form_test\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\schema_form\SchemaFormBase;

/**
 * Example form class for testing schema-based form generation.
 *
 * This class demonstrates the usage of SchemaFormBase by generating a form from
 * the 'schema_form_test.my_form' schema definition. It provides custom default
 * values and handles form submission.
 */
class MyForm extends SchemaFormBase {

  /**
   * {@inheritdoc}
   */
  public function getSchemaFormSchema(): string|null {
    return 'schema_form_test.my_form';
  }

  /**
   * {@inheritdoc}
   *
   * Provides default values for the test form fields including:
   * - field_string_one: A sample string value
   * - group_one.min_max_group: An array with min and max values.
   */
  public function getSchemaFormDefaultValues(): array {
    return [
      'field_string_one' => 'My first value',
      'group_one' => [
        'min_max_group' => [
          'min' => 1,
          'max' => 21,
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->messenger()->addMessage($this->t('Form submitted successfully.'));
  }

}
