const assert = require('assert');

module.exports = {
  '@tags': ['schema_form'],
  before(browser) {
    browser.drupalInstall({
      installProfile: 'schema_form_test_profile',
    });
  },
  after(browser) {
    browser.drupalUninstall();
  },
  'Check the main functionality': async (browser) => {
    browser
      .drupalRelativeURL('/schema-form-test/my-config-form')
      .assert.textContains('h1', 'My Config Form')
      .drupalRelativeURL('/schema-form-test/my-config-form-design1')
      .assert.textContains('h1', 'My Config Form - design 1')

      .drupalRelativeURL('/schema-form-test/my-config-form-design2')
      .assert.textContains('h1', 'Access denied')
      .thLogin('admin')
      .drupalRelativeURL('/schema-form-test/my-config-form-design2')
      .assert.textContains('h1', 'My Config Form - design 2')

      .drupalRelativeURL('/schema-form-test/my-form')
      .assert.textContains('h1', 'My Form')
      .click('#edit-submit')
      .assert.textContains('body', 'The "max" plugin does not exist')

      .drupalRelativeURL('/admin/config/content')
      .click('link text', 'Schema Form designs')
      // .click('Add Schema Form Design')
      .drupalRelativeURL('/admin/config/content/schema-form-design/add')
      .assert.textContains(
        '#edit-design--description',
        'Enter the form element configuration in YAML format, example:',
      )
      .setValue('[name=id]', 'schema_form_test.my_form')
      .setValue('[name=label]', 'My form: version 1.234!')
      .setValue('[name=schema]', 'schema_form_test.my_form')
      .setValue(
        '[name=design]',
        `
        mapping:
          field_two:
            description: Description to be overridden.
            form_element:
              '#type': textarea
              '#title': My test field two
              '#description': My test field two description!
      `,
      )
      .click('#edit-submit')
      .assert.textContains('table', 'My form: version 1.234!')
      .thGetConfig('schema_form.design.schema_form_test.my_form', (result) => {
        assert.ok(!result.value.design.includes('\r\n'));
      })

      // Check Custom Config Entity Form.
      .drupalRelativeURL('/admin/config/content/schema_form_test_ent_one/add')
      .assert.textContains('h1', 'Add schema form test entity one')
      .setValue('[name=id]', 'my_id1')
      .setValue('[name=fieldOneInt]', '42')
      .setValue('[name=field_string_three]', 'My id 1')
      .click('#edit-submit')
      .assert.textContains('table', 'my_id1')
      .assert.textContains('table', 'My id 1')
      .click('link text', 'My id 1')
      .setValue('[name=id]', 'my_id_1.1')
      .setValue('[name=field_string_three]', 'My new id 1.1')
      .click('#edit-submit')
      .assert.textContains('table', 'my_id_1.1')
      .assert.textContains('table', 'My new id 1.1');
  },
};
