<?php

namespace Drupal\schema_occupation\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_web_page_type' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_occupation_type",
 *   label = @Translation("@type"),
 *   description = @Translation("REQUIRED. The type of occupation."),
 *   name = "@type",
 *   group = "schema_occupation",
 *   weight = -5,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "type",
 *   tree_parent = {
 *     "Occupation",
 *   },
 *   tree_depth = -1,
 * )
 */
class SchemaOccupationType extends SchemaNameBase {

}
