<?php

declare(strict_types=1);

namespace Drupal\schema_software_application\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'DownloadUrl' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_software_application_download_url",
 *   label = @Translation("downloadUrl"),
 *   description = @Translation("If the file can be downloaded, URL to download the binary."),
 *   name = "DownloadUrl",
 *   group = "schema_software_application",
 *   weight = 0,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = TRUE,
 *   property_type = "url",
 *   tree_parent = {},
 *   tree_depth = -1,
 * )
 */
class SchemaSoftwareApplicationDownloadUrl extends SchemaNameBase {

}
