<?php

declare(strict_types=1);

namespace Drupal\schema_software_application\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_software_application_offers' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_software_application_offers",
 *   label = @Translation("Offers"),
 *   description = @Translation("PRICE REQUIRED BY GOOGLE. An offer to sell the app. If the app is free of charge, set offers.price to 0. "),
 *   name = "offers",
 *   group = "schema_software_application",
 *   weight = 11,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = TRUE,
 *   property_type = "offer",
 *   tree_parent = {},
 *   tree_depth = 0,
 * )
 */
class SchemaSoftwareApplicationOffers extends SchemaNameBase {

}
