<?php

declare(strict_types=1);

namespace Drupal\schema_software_application\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides the 'schema_software_application_released_event' meta tag plugin.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_software_application_released_event",
 *   label = @Translation("releasedEvent"),
 *   description = @Translation("Details about the original release of the work. Google expects only the country of the location."),
 *   name = "releasedEvent",
 *   group = "schema_software_application",
 *   weight = 5,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = TRUE,
 *   property_type = "event",
 *   tree_parent = {
 *     "PublicationEvent",
 *   },
 *   tree_depth = 0,
 * )
 */
class SchemaSoftwareApplicationReleasedEvent extends SchemaNameBase {

  /**
   * Generate a form element for this meta tag.
   */
  public function form(array $element = []): array {
    $form = parent::form($element);

    // This should only be a PublicationEvent.
    unset($form['@type']['#options']['Event']);

    // Highlight the fields that Google recommends.
    $recommended = ['startDate', 'location'];
    foreach ($recommended as $key) {
      $description = $this->t('RECOMMENDED BY GOOGLE.') . ' ' . $form[$key]['#description'];
      $form[$key]['#description'] = $description;
    }

    return $form;
  }

}
