<?php

declare(strict_types=1);

namespace Drupal\schema_software_application\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides the 'schema_software_application_software_version' meta tag plugin.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_software_application_software_version",
 *   label = @Translation("softwareVersion"),
 *   description = @Translation("Version of the software instance."),
 *   name = "softwareVersion",
 *   group = "schema_software_application",
 *   weight = -2,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "text",
 *   tree_parent = {},
 *   tree_depth = -1,
 * )
 */
class SchemaSoftwareApplicationSoftwareVersion extends SchemaNameBase {

}
