<?php

declare(strict_types=1);

namespace Drupal\schema_software_application\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_software_application_type' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_software_application_type",
 *   label = @Translation("@type"),
 *   description = @Translation("REQUIRED."),
 *   name = "@type",
 *   group = "schema_software_application",
 *   weight = -10,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "type",
 *   tree_parent = {
 *     "SoftwareApplication",
 *   },
 *   tree_depth = -1,
 * )
 */
class SchemaSoftwareApplicationType extends SchemaNameBase {

  /**
   * {@inheritdoc}
   */
  public static function labels() {
    return [
      'SoftwareApplication',
    ];
  }

}
