<?php

namespace Drupal\schema_vacation_rental\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_vacation_rental_id' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_vacation_rental_contains_place",
 *   label = @Translation("containsPlace"),
 *   description = @Translation("The basic containment relation between a place and whatever it contains."),
 *   name = "containsPlace",
 *   group = "schema_vacation_rental",
 *   weight = -1,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "accommodation",
 *   tree_parent = {},
 *   tree_depth = -1,
 * )
 */
class SchemaVacationContainsPlace extends SchemaNameBase {

}
