<?php

namespace Drupal\schema_vacation_rental\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_vacation_rental_amenity_feature' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_vacation_rental_amenity_feature",
 *   label = @Translation("amenityFeature"),
 *   description = @Translation("Features present in the vacation rental."),
 *   name = "amenityFeature",
 *   group = "schema_vacation_rental",
 *   weight = 11,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = TRUE,
 *   property_type = "location_feature_specification",
 *   tree_parent = {
 *     "LocationFeatureSpecification",
 *   },
 *   tree_depth = 0,
 * )
 */
class SchemaVacationRentalAmenityFeature extends SchemaNameBase {

}
