<?php

namespace Drupal\schema_vacation_rental\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_vacation_rental_pets_allowed' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_vacation_rental_pets_allowed",
 *   label = @Translation("Pets allowed"),
 *   description = @Translation("Indicates whether pets are allowed to enter the accommodation or lodging business. More detailed information can be put in a text value"),
 *   name = "pets_allowed",
 *   group = "schema_vacation_rental",
 *   weight = -1,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "text",
 *   tree_parent = {},
 *   tree_depth = -1,
 * )
 */
class SchemaVacationRentalPetsAllowed extends SchemaNameBase {

}
