<?php

namespace Drupal\schema_vacation_rental\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_vacation_rental_type' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_vacation_rental_type",
 *   label = @Translation("@type"),
 *   description = @Translation("REQUIRED. The type of VacationRental."),
 *   name = "@type",
 *   group = "schema_vacation_rental",
 *   weight = -10,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   property_type = "text",
 *   tree_parent = {},
 *   tree_depth = -1,
 * )
 */
class SchemaVacationRentalType extends SchemaNameBase {

}
