<?php

namespace Drupal\Tests\schemaapp\Unit;

use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request;


/**
 * Test version of SchemaAppCacheSkeleton with in-memory cache and injectable Guzzle client.
 */
class SchemaAppCacheLocal extends SchemaAppCacheSkeleton {
  public array $internalCache = [];
  public $guzzleClient;

  public function __construct($url, $config) {
    parent::__construct($url, $config);
  }

  protected function getGuzzle() {
    return $this->guzzleClient;
  }

  public function setCache(array $contents, string $cachePrefix = '', $duration = NULL): void {
    $itemUrl = $cachePrefix . md5($this->pageUrl);
    $this->internalCache[$itemUrl] = $contents;
  }

  public function checkCache(string $cachePrefix = '') {
    $itemUrl = $cachePrefix . md5($this->pageUrl);
    if (isset($this->internalCache[$itemUrl])) {
      $obj = new \stdClass();
      $obj->data = $this->internalCache[$itemUrl];
      return $obj;
    }
    return FALSE;
  }
}
