Schema.org Blueprints: Roadmap
------------------------------

# Pre-Alpha (Dev)

- Fix issues as they come up with or without issues or MRs.
- Build out APIs' and hooks.
- Define core dependencies.
- Implement core submodules.
--------------------------------------------------------------------------------
- Research and document recommended modules.
- Determine the recommended types per entity type.
  - Document tested and supported default Schema.org types.
  - Always review default Schema.org type properties.
- Build out the default schema types properties.
- Review patterns and tests.
- Remove experimental tag from most sub-modules.


# Alpha

- Define baseline Schema.org types and properties
- Establish sub-modules and feature list
--------------------------------------------------------------------------------
- Ensure baseline test coverage
- Finalize core dependencies
- Research and support contrib modules
- Remove deprecated modules
- Review and clean up code base as issues are reported. 


# Beta

- Find co-maintainers and sponsoring organizations
- Provide training videos
- Determine upgrade path between Schema.org versions
--------------------------------------------------------------------------------
- Finalize and document hooks and APIs
- Ensure regression test coverage
- Establish supported contrib modules


# Stable

- Add Schema.org types and properties as needed
- Provide additional enhancements via custom code or contrib modules
--------------------------------------------------------------------------------
- Require tests coverage for all changes
