Table of contents
-----------------

* Introduction
* Features
* Requirements
* Configuration
* References
* Notes


Introduction
------------

The **Schema.org Blueprints Layout Paragraphs** provides integration with
the Layout Paragraphs module.

> For a full demo of the Schema.org Blueprints and Layout Paragraphs 
> (with Mercury Editor) check out the 
> [Layout Starterkit](https://www.drupal.org/project/schemadotorg_starterkit_layout).


Features
--------

- Automatically adds and configures layout paragraphs field storage,
  instance, form display, and view display.
- Configure paragraph libraries support when the 'Layout Paragraphs Library'
  module is enabled.
- Automatically adds types to the paragraph node's target bundles.
- Automatically enable 'Style options' for default layout paragraph types.


Requirements
------------

**[Layout Paragraphs](https://www.drupal.org/project/layout_paragraphs)**  
Field widget and formatter for using layouts with paragraph fields.


Configuration
-------------

- Go to the Schema.org types configuration page.  
  (/admin/config/schemadotorg/settings/types#edit-schemadotorg-layout-paragraphs)
- Go to the 'Layout paragraphs settings' details.
- Enter Schema.org types that default to using layout paragraphs.
- Enter the default paragraph types to be using with in layout paragraphs.
- Enter the components that should be included in the default view display when layout paragraphs is enabled.


References
----------

- [Talking Drupal #337 - Layout Paragraphs](https://www.talkingdrupal.com/337)
- [Decoupling Acromedia.com with Drupal 9 & React](https://www.acromedia.com/article/decoupling-acromediacom-with-drupal-9-react)
- [Paragraphs vs Layout Builder in Drupal](https://www.mediacurrent.com/videos/paragraphs-vs-layout-builder-drupal)
- [Layout Paragraphs: A new way to manage Paragraphs](https://www.morpht.com/blog/layout-paragraphs-new-way-manage-paragraphs)


Notes
-----

- Icons are from [Font Awesome](https://fontawesome.com/)
