(function ($, Drupal) {
  Drupal.behaviors.scrollDepthIndicator = {
    attach(context, settings) {
      // Define indicator element
      const indicator = `
        <div id="scroll-depth-indicator-wrapper" class="scroll-depth-indicator-wrapper">
          <div class="scroll-progress"></div>
        </div>
      `;

      // Retrieve dynamic selector details from Drupal settings
      const dynamicSelector =
        drupalSettings.scroll_depth_indicator.dynamicSelector;

      // Get dynamic selector and type
      const selectorType = dynamicSelector.selectorType;
      const selector = dynamicSelector.selector;

      // Get restrictions
      const notRestricted = drupalSettings.scroll_depth_indicator.enabled;
      // Show progress indicator only if there are no content type restrictions
      if (notRestricted) {
        // Define dynamic selector element based on type within the context
        let progressIndicatorSelector;

        // Find the dynamic selector element within the context with different types of selectors
        switch (selectorType) {
          case 'class':
            // Prepend '.' for class selector
            progressIndicatorSelector = $(context).find(`.${selector}`);
            break;
          case 'element':
            // Do not prepend anything for element selector
            progressIndicatorSelector = $(context).find(selector);
            break;
          case 'id':
            // Prepend '#' for ID selector
            progressIndicatorSelector = $(context).find(`#${selector}`);
            break;
          default:
            progressIndicatorSelector = $(context).find(selector);
            break;
        }

        // Append the indicator element to the dynamic selector
        if (!$('#scroll-depth-indicator-wrapper').length) {
          progressIndicatorSelector.append(indicator);
        }

        // Identify the height of the web page and window
        const pageHeight = $(document).height();
        let windowHeight = $(window).height();
        const scrollTop = $(window).scrollTop();
        let scrollProgress = null;

        // Function to update the width of the indicator based on the scroll progress
        const updateIndicatorWidth = (scrollTop) => {
          scrollProgress = Math.ceil(
            (scrollTop / (pageHeight - windowHeight)) * 100,
          );
          $('.scroll-progress').width(`${scrollProgress}%`);
        };

        // Update the initial width of the indicator based on the scroll progress
        updateIndicatorWidth(scrollTop);

        // Update window height on window resize
        $(window).on('resize', function () {
          windowHeight = $(window).height();
        });

        // Attach scroll event listener to the window
        $(window).on('scroll', function () {
          // Update the width of the indicator while scrolling
          updateIndicatorWidth($(window).scrollTop());
        });
      }
    },
  };
})(jQuery, Drupal);
