((Drupal, once) => {
  Drupal.behaviors.scrollUpDown = {
    attach: (context) => {
      once("scroll-up-down", "body", context).forEach(() => {
        function createButton(className, ariaLabel, callback) {
          const btn = document.createElement("button");
          btn.type = "button";
          btn.className = `sud-button ${className}`;
          btn.setAttribute("aria-label", ariaLabel);
          btn.innerHTML = `<span class="sud-visually-hidden">${ariaLabel}</span>`;
          btn.addEventListener("click", callback);

          return btn;
        }

        const wrapper = document.createElement("div");
        wrapper.className = "scroll-up-down";

        const btnUp = createButton(
          "sud-button--up",
          Drupal.t("Scroll to top"),
          () => window.scrollTo({ top: 0, behavior: "smooth" }),
        );

        const btnDown = createButton(
          "sud-button--down",
          Drupal.t("Scroll to bottom"),
          () =>
            window.scrollTo({
              top: document.body.scrollHeight,
              behavior: "smooth",
            }),
        );

        wrapper.appendChild(btnUp);
        wrapper.appendChild(btnDown);
        document.body.appendChild(wrapper);

        const toggleVisibility = () => {
          const scrollY = window.scrollY || document.documentElement.scrollTop;
          const threshold = 100;

          if (scrollY > threshold) {
            btnUp.classList.add("sud-button--visible");
            btnDown.classList.add("sud-button--visible");
          } else if (
            document.activeElement !== btnUp &&
            document.activeElement !== btnDown
          ) {
            btnUp.classList.remove("sud-button--visible");
            btnDown.classList.remove("sud-button--visible");
          }
        };

        window.addEventListener("scroll", toggleVisibility, { passive: true });
        toggleVisibility();
      });
    },
  };
})(Drupal, once);
