((Drupal, once) => {
  Drupal.behaviors.scrollUpDown = {
    attach: (context) => {
      once("scroll-up-down", "body", context).forEach(() => {
        function createButton(className, ariaLabel, callback) {
          const btn = document.createElement("button");
          btn.type = "button";
          btn.className = `sud-button ${className}`;
          btn.setAttribute("aria-label", ariaLabel);
          btn.innerHTML = `<span class="sud-visually-hidden">${ariaLabel}</span>`;
          btn.addEventListener("click", callback);

          return btn;
        }

        function getScrollBehavior() {
          const html = document.documentElement;
          const behavior = window.getComputedStyle(html).scrollBehavior;
          return behavior === "smooth" ? "auto" : "smooth";
        }

        const wrapper = document.createElement("nav");
        wrapper.className = "scroll-up-down";
        wrapper.setAttribute("aria-labelledby", "scroll-controls-label");

        const btnUp = createButton(
          "sud-button--up",
          Drupal.t("Scroll to top"),
          () => {
            window.scrollTo({ top: 0, behavior: getScrollBehavior() });
            btnUp.blur();
          },
        );

        const btnDown = createButton(
          "sud-button--down",
          Drupal.t("Scroll to bottom"),
          () => {
            window.scrollTo({
              top: document.body.scrollHeight,
              behavior: getScrollBehavior(),
            });
            btnDown.blur();
          },
        );

        const controlsLabel = document.createElement("span");
        controlsLabel.id = "scroll-controls-label";
        controlsLabel.className = "sud-visually-hidden";
        controlsLabel.innerHTML = Drupal.t("Scroll controls");

        wrapper.appendChild(controlsLabel);
        wrapper.appendChild(btnUp);
        wrapper.appendChild(btnDown);
        document.body.appendChild(wrapper);

        const minScreens = 3;
        const showAfter = 0.25;

        const toggleVisibility = () => {
          const scrollY = window.scrollY || document.documentElement.scrollTop;
          const viewportHeight = window.innerHeight;
          const pageHeight = document.documentElement.scrollHeight;

          if (pageHeight < viewportHeight * minScreens) {
            wrapper.classList.remove("scroll-up-down--visible");
            return;
          }

          const threshold = viewportHeight * showAfter;

          if (scrollY > threshold) {
            wrapper.classList.add("scroll-up-down--visible");
          } else if (
            document.activeElement !== btnUp &&
            document.activeElement !== btnDown
          ) {
            wrapper.classList.remove("scroll-up-down--visible");
          }
        };

        window.addEventListener("scroll", toggleVisibility, { passive: true });
        toggleVisibility();
      });
    },
  };
})(Drupal, once);
