# SDC Canvas Theme

A modern, component-based Drupal theme built with Single Directory Components (SDC), Tailwind CSS, and Storybook for the Drupal Canvas ecosystem.

## Features

- **Component-Based Architecture**: Built using Drupal's Single Directory Components (SDC)
- **Modern CSS**: Styled with Tailwind CSS for responsive, utility-first design
- **Storybook Integration**: Interactive component development and documentation
- **Twig Templates**: Clean, maintainable template structure
- **SCSS Support**: Advanced styling with Sass preprocessing
- **Responsive Design**: Mobile-first approach with breakpoint management
- **Accessibility**: WCAG compliant components and markup

## Prerequisites

Before installing this theme, ensure you have the following:

- **Node.js**: Version 20.x (LTS recommended)
- **npm**: Version 10.x or higher
- **Composer**: For PHP dependencies
- **Docker/Lando**: For local development environment (recommended)
- **Git**: For version control

## Installation

### 1. Install Node Version Manager (nvm)

```bash
# Install nvm (if not already installed)
curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.0/install.sh | bash

# Restart your terminal or run:
source ~/.bashrc

# Install Node.js version 20
nvm install 20

# Use Node.js version 20
nvm use 20

# Verify installation
node --version  # Should show v20.x.x
npm --version   # Should show 10.x.x or higher
```

### 2. Clone the Repository

```bash
# Navigate to your Drupal themes directory
cd web/themes/custom/

# Clone the theme
git clone [repository-url] sdc_canvas_theme

# Navigate to the theme directory
cd sdc_canvas_theme
```

### 3. Install Dependencies

```bash
# Install Node.js dependencies
npm install

# This will install:
# - Storybook for component development
# - Tailwind CSS for styling
# - Various build tools and utilities
```

### 4. Build the Theme Assets

```bash
# Build the theme for production
npm run build

# This command will:
# - Transform design tokens from Figma
# - Compile SCSS files to CSS
# - Optimize assets for production
```

### 5. Enable the Theme in Drupal

1. **Clear Drupal Cache**:
   ```bash
   # If using Drush
   drush cr

   # Or via Drupal admin: Administration > Configuration > Development > Performance > Clear all caches
   ```

2. **Enable the Theme**:
   - Go to `Administration > Appearance` in your Drupal admin
   - Find "SDC Canvas Theme" in the list
   - Click "Install and set as default" or "Install"

3. **Configure Theme Settings** (Optional):
   - Go to `Administration > Appearance > Settings > SDC Canvas Theme`
   - Configure social media links, site branding, etc.

## Development Workflow

### Starting Development Server

```bash
# Start Storybook for component development
npm run dev:storybook

# This will start Storybook on http://localhost:6006
# You can view and interact with all components
```

### Building for Development

```bash
# Build assets with file watching (development mode)
npm run watch

# This will watch for changes and rebuild automatically
```

### File Structure

```
sdc_canvas_theme/
├── components/                 # Single Directory Components
│   ├── 00-base/               # Base/global components
│   ├── 01-atoms/              # Atomic components
│   ├── 02-molecules/          # Molecular components
│   └── 03-organisms/          # Organism components
├── .storybook/                # Storybook configuration
├── templates/                 # Drupal page templates
├── figma/                     # Design tokens from Figma
├── package.json               # Node.js dependencies
├── tailwind.config.js         # Tailwind CSS configuration
├── gulpfile.js               # Build automation
├── sdc_canvas_theme.theme    # Drupal theme hooks
├── sdc_canvas_theme.info.yml # Theme metadata
└── README.md                 # This file
```

### Component Development

Each component follows the SDC structure:

```
component-name/
├── component-name.component.yml  # Component definition
├── component-name.twig          # Twig template
├── component-name.scss          # Component styles
└── component-name.js           # Component JavaScript (if needed)
```

### Available Scripts

```bash
# Development
npm run dev:storybook    # Start Storybook development server
npm run watch           # Watch files and rebuild on changes

# Building
npm run build           # Production build
npm run build:storybook # Build Storybook for deployment

# Tokens
npm run tokens          # Transform Figma design tokens
```

## Configuration

### Tailwind CSS

The theme uses Tailwind CSS with custom configuration. Key settings:

- **Content Paths**: Configured to scan Twig templates and PHP files
- **Design Tokens**: Integrated with Figma design tokens
- **Custom Utilities**: Extended with theme-specific utilities

### Storybook

Storybook is configured for:
- Component isolation and testing
- Interactive documentation
- Visual regression testing
- Accessibility testing

### Drupal Integration

The theme integrates with Drupal through:
- **Menu System**: Header and footer use Drupal menus
- **Theme Settings**: Configurable options via Drupal admin
- **Preprocess Functions**: PHP hooks for dynamic data

## Menus and Navigation

### Setting Up Menus

1. **Main Navigation** (Header):
   - Create a menu called "Main navigation" in Drupal
   - Add menu items for primary site navigation
   - The header component will automatically display these

2. **Footer Menu**:
   - Create a menu called "Footer" in Drupal
   - Add secondary navigation items
   - The footer component will display these links

### Menu Configuration

- Go to `Administration > Structure > Menus`
- Create the required menus
- Add menu items with appropriate titles and URLs

## Customization

### Adding New Components

1. Create a new directory in the appropriate component level
2. Add the required files (`.component.yml`, `.twig`, `.scss`)
3. Register the component in Storybook (automatic via glob patterns)
4. Use the component in your templates

### Modifying Styles

- Edit SCSS files in component directories
- Use Tailwind utilities in templates
- Custom CSS can be added to component-specific SCSS files

### Theme Settings

Configure theme-specific settings:
- Social media links
- Site branding options
- Color schemes
- Layout options

## Troubleshooting

### Common Issues

1. **Build Fails**:
   ```bash
   # Clear node_modules and reinstall
   rm -rf node_modules package-lock.json
   npm install
   ```

2. **Storybook Won't Start**:
   ```bash
   # Check Node.js version
   nvm use 20
   npm run dev:storybook
   ```

3. **Styles Not Loading**:
   ```bash
   # Rebuild assets
   npm run build
   # Clear Drupal cache
   drush cr
   ```

4. **Components Not Appearing**:
   - Check component YAML syntax
   - Ensure component status is not "obsolete"
   - Verify file paths in Storybook config

### Getting Help

- **Documentation**: Check Drupal.org Canvas documentation
- **Issues**: Report bugs on the project issue queue
- **Community**: Join Drupal Canvas discussions

## Contributing

1. Follow Drupal coding standards
2. Use meaningful commit messages
3. Test components in Storybook
4. Ensure accessibility compliance
5. Update documentation as needed

## License

This theme is licensed under the GPL-2.0-or-later license.

## Credits

- Built for the Drupal Canvas ecosystem
- Uses modern frontend tooling and best practices
- Designed for maintainable, scalable Drupal theming