(function () {
  'use strict';

  // Initialize Splide sliders when DOM is ready
  document.addEventListener('DOMContentLoaded', function () {
    initImageGridSliders();
  });

  // Also initialize on Drupal behaviors for dynamic content
  if (typeof Drupal !== 'undefined' && Drupal.behaviors) {
    Drupal.behaviors.imageGridSlider = {
      attach: function (context, settings) {
        initImageGridSliders(context);
      }
    };
  }

  function initImageGridSliders(context) {
    var elements = (context || document).querySelectorAll('.image-slider');

    elements.forEach(function (element) {
      // Skip if already initialized
      if (element.splide) {
        return;
      }

      // Get image count from data attribute
      var imageCount = parseInt(element.closest('.image-grid').getAttribute('data-image-count')) || 0;

      // Only initialize slider if we have 4+ images
      if (imageCount < 4) {
        return;
      }

      var splide = new Splide(element, {
        type: 'loop',
        perPage: 3,
        perMove: 1,
        gap: '1rem',
        pagination: true,
        arrows: true,
        breakpoints: {
          1024: {
            perPage: 2,
          },
          768: {
            perPage: 1,
          },
        },
      });

      splide.mount();
    });
  }

  // Expose init function globally for manual initialization if needed
  window.initImageGridSliders = initImageGridSliders;
})();
