const gulp = require('gulp');
const postcss = require('gulp-postcss');
const tailwindcss = require('tailwindcss');
const autoprefixer = require('autoprefixer');
const nested = require('postcss-nested');
const rename = require('gulp-rename');
const cleanCSS = require('gulp-clean-css');
const sass = require('gulp-sass')(require('sass'));

gulp.task('compileSCSS', () => {
  return gulp
    .src('./**/*.scss', { base: './' })
    .pipe(sass().on('error', sass.logError))
    .pipe(
      postcss([
        nested(),
        tailwindcss('./tailwind.config.js'),
        autoprefixer(),
      ])
    )
    .pipe(
      rename((filePath) => {
        filePath.extname = '.css';
      })
    )
    .pipe(cleanCSS())
    .pipe(gulp.dest('./'));
});

gulp.task('watch', () => {
  gulp.watch(
    ['./**/*.scss', './components/**/*.twig', './templates/**/*.html.twig'],
    gulp.series('compileSCSS')
  );
});

gulp.task('default', gulp.series('compileSCSS'));
