# SDC - Components library Module

## Overview

The SDC Component Library module provides a visual preview of Single Directory
Components (SDC) defined in a Drupal theme. Components are represented using
`.story.twig` files located in the components directory of the active theme,
with dummy data included. The module dynamically renders these components at the
`/components` page, making it easier for developers to see how components look
with example data.

Features:
- Automatically locates and renders `.story.twig` files from the active theme's components folder.
- Allows developers to visually preview components at `/components`.
- Supports the inclusion of dummy data via a .component.yml file for each component, enabling realistic previews.
- Dynamically adapts to the active theme without hardcoding the theme name.

## How It Works

In your theme's components directory, create your component templates (e.g.,
button, card, etc.). Each component has two key files:
- A `.story.twig file`: This is used for visualizing the component, and it includes the main component template.
- An optional `.component.yml` file: Defines the component’s metadata and dummy data (like props) used in the preview.

In the `.story.twig` file, you will include the actual component template along
with dummy data, typically provided in the `.component.yml` file.

When you visit `/components`, the module automatically scans the active theme
for all `.story.twig` files, renders them, and displays them on a single page.
This gives you a visual overview of how your components look and behave with the
example data.

## Requirements

- A Drupal 9+ installation.
- A custom or existing theme with a components folder structure as outlined below.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

Enable the module using the following Drush command or the Drupal UI:

`drush en sdc_component_library`

## File Structure

Ensure your theme contains a components directory where you store your component
templates. The components in your theme should follow this structure:

```shell
/themes/custom/your_theme/components/
├── atoms/
│   ├── button.story.twig
│   ├── button.twig
│   ├── button.component.yml
├── molecules/
│   ├── card.story.twig
│   ├── card.twig
│   ├── card.component.yml
└── ...
```

- button.story.twig: The Twig template that includes the main component with example data.
- button.component.yml: The YAML file that defines the properties (props) and example data for the component.

## Example `.story.twig`

For each component, the `.story.twig` file includes the actual component with dummy data:

```twig
{# button.story.twig #}
{% include active_theme() ~ ':button' with {
  label: 'Click Me',
  icon: 'arrow-right'
} only %}
```

If you want to call the component from a specific theme (for example `my_theme`) you can use that theme machine name when calling the component:

```twig
{# button.story.twig #}
{% include 'my_theme:button' with {
  label: 'Click Me',
  icon: 'arrow-right'
} only %}
```

## Example `.component.yml`

The optional `.component.yml` file stores metadata about the component and example data:

```yaml
name: Button Component
description: A simple button component
group: Atoms
props:
  type: object
  properties:
    label:
      type: string
      examples:
        - "Click Me"
    icon:
      type: string
      examples:
        - "arrow-right"
```

## Usage

Once you have set up your components, visit `/components` in your browser. The
module will automatically scan for `.story.twig` files in your theme's
components directory and render each component with the provided dummy data.

The page will display:

- The name and description of the component (from the YAML file).
- The rendered component itself (from the `.story.twig` file).

## Customization

- Component Data: Customize the data displayed in your components by editing the corresponding .component.yml file.
- Component Organization: Organize components into different folders (e.g., atoms, molecules, organisms) under your theme's components directory.

## Extending

You can extend this module by:

- Adding more complex example data to your `.component.yml` files.
- Introducing custom styling or JS libraries by attaching them in the `libraries.yml` file.

## Support

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search/sdc_component_library).
