# Preparing for Drupal.org Contribution

This document outlines the steps needed to prepare this module for submission to Drupal.org.

## ✅ Completed Steps

1. ✅ Added LICENSE.txt with GPL-2.0+ license
2. ✅ Updated README.md to remove site-specific references
3. ✅ Updated .info.yml description to be generic
4. ✅ Updated package.json license to GPL-2.0+
5. ✅ Updated .gitignore to exclude build artifacts
6. ✅ Added .gitattributes for Drupal.org packaging
7. ✅ Removed "PR Builder" references from code comments

## 📋 Next Steps Before Submission

### 1. Code Standards Compliance

Run Drupal coding standards checks:

```bash
# Install PHPCS and Drupal Coder
composer require --dev drupal/coder
vendor/bin/phpcs --standard=Drupal,DrupalPractice web/modules/custom/sdc_inline_editor

# Fix auto-fixable issues
vendor/bin/phpcbf --standard=Drupal,DrupalPractice web/modules/custom/sdc_inline_editor
```

### 2. Create a Git Repository

If not already done, initialize a git repository:

```bash
cd web/modules/custom/sdc_inline_editor
git init
git add .
git commit -m "Initial commit for Drupal.org contribution"
```

### 3. Review Dependencies

Ensure all dependencies are:
- Available on Drupal.org (for contributed modules)
- Properly declared in `.info.yml`
- Have compatible versions

Current dependencies:
- `inline_entity_form` - ✅ Available on Drupal.org
- `entity_browser` - ✅ Available on Drupal.org
- Core modules: `field`, `image`, `media`, `media_library`, `views` - ✅ Core

### 4. Documentation

Consider adding:
- **API documentation** in docblocks (already partially done)
- **Installation instructions** in README.md
- **Configuration guide** in README.md
- **Examples** of component usage

### 5. Testing

Consider adding:
- **Unit tests** for services
- **Functional tests** for controllers
- **Kernel tests** for integration

### 6. Version Numbering

The module currently has version `1.0.0` in `.info.yml`. For Drupal.org:
- Use semantic versioning (e.g., `8.x-1.0` for Drupal 8/9/10, `11.x-1.0` for Drupal 11)
- Or use `1.0.0` format (Drupal.org will handle conversion)

### 7. Build Process

Ensure build artifacts are:
- ✅ Excluded from git (via .gitignore)
- ✅ Excluded from Drupal.org packaging (via .gitattributes)
- Documented in README.md how to build

### 8. Submodule Consideration

The `sdc_inline_editor_media` submodule should be:
- Either included as part of the main module
- Or submitted as a separate project
- Documented clearly in the main module's README

### 9. Drupal.org Project Application

When ready to submit:

1. **Create a Drupal.org account** (if you don't have one)
2. **Apply for a new project**: https://www.drupal.org/node/add/project-module
3. **Fill out the project application**:
   - Project name: `sdc_inline_editor`
   - Short description: "Provides a visual inline editor for building content using Single Directory Components (SDCs)"
   - Full description: Use content from README.md
   - License: GPL-2.0+
   - Development status: Alpha/Beta/Stable (choose appropriate)
   - Maintenance status: Seeking co-maintainers (if applicable)

### 10. Git Repository Setup

Drupal.org uses GitLab. After project approval:

1. Clone the repository from Drupal.org
2. Add your local code
3. Push to Drupal.org's GitLab instance

### 11. Release Management

After initial submission:
- Create releases using semantic versioning
- Tag releases in git
- Update release notes on Drupal.org

## 📝 Additional Recommendations

### Security Review
- Review all user inputs for XSS vulnerabilities
- Ensure CSRF protection on all forms
- Validate all API inputs

### Performance
- Consider caching strategies
- Review JavaScript bundle size
- Optimize asset loading

### Accessibility
- Ensure keyboard navigation works
- Test with screen readers
- Follow WCAG guidelines

### Browser Compatibility
- Test in major browsers
- Document supported browsers

## 🔗 Helpful Resources

- [Drupal.org Module Application Guide](https://www.drupal.org/docs/develop/managing-a-drupal-org-theme-module-or-distribution-project/applying-for-a-new-project)
- [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards)
- [Drupal.org Git Documentation](https://www.drupal.org/docs/develop/git)
- [Semantic Versioning](https://semver.org/)

## ⚠️ Important Notes

1. **Build Artifacts**: The `js/dist/` directory should NOT be committed to git. Users will need to run `npm install && npm run build` after downloading.

2. **Node Modules**: Ensure `node_modules/` is in `.gitignore` and `.gitattributes` export-ignore.

3. **License Compatibility**: All dependencies must be GPL-2.0+ compatible. The `ckeditor5-premium-features` package may need review for commercial licensing.

4. **Component Examples**: The included SDC components (`text-block`, `hero-image`, etc.) are examples. Consider if they should be:
   - Included as examples
   - Moved to a separate example module
   - Documented as optional

5. **Configuration**: Review all configuration files in `config/install/` to ensure they're generic and don't contain site-specific data.

