# SDC Inline Editor

Provides a visual inline page builder for creating and editing content using Drupal's Single Directory Components (SDCs) with drag-and-drop functionality and server-side rendering.

## Introduction

SDC Inline Editor transforms how content creators build pages in Drupal by providing a visual, drag-and-drop interface powered by Single Directory Components. Instead of writing HTML or learning complex Drupal configuration, content editors can build rich, interactive pages by simply dragging components onto the page and editing them inline. The module stores content as structured SDC components rather than raw HTML, ensuring consistency, reusability, and optimal performance through server-side rendering.

**Summary (200 characters):** Visual inline page builder for Drupal using Single Directory Components. Drag-and-drop interface with server-side rendering. Enables content creators to build rich pages without coding.

## Features
 
### Basic Functionality

SDC Inline Editor provides a complete visual page building experience:

- **Drag-and-Drop Interface**: Add, rearrange, and remove components directly on the page
- **Inline Editing**: Click any editable field to edit content directly where it appears
- **Component-Based Architecture**: Build pages using reusable Single Directory Components
- **Server-Side Rendering**: Content is rendered on the server for optimal performance and SEO
- **WYSIWYG Editing**: Rich text editing powered by CKEditor 5 for text fields
- **Media Library Integration**: Select images and media directly from Drupal's media library
- **Component Toolbar**: Quick access to add new components, delete, move, and configure settings
- **Sidebar Configuration**: Edit component properties like image sizes, alignment, and other settings in a convenient sidebar panel

### Unique Features

- **SDC Component Storage**: Content is stored as structured SDC components (`<sdc-component-name sdc-data='{...}'/>`) rather than raw HTML, enabling component reusability and consistency
- **Mixed Content Support**: Seamlessly mix SDC components with regular HTML content
- **Nested Components**: Support for components within components with configurable drop zones
- **Component Restrictions**: Control which components can be dropped into specific containers
- **Granular Permissions**: Fine-grained permission system for different editing capabilities
- **Session-Based Editing**: Editing mode persists across page refreshes during active editing sessions
- **Validation System**: Built-in validation ensures only valid SDC components are saved

### Use Cases

- **Marketing Teams**: Create landing pages, promotional content, and campaign pages without developer assistance
- **Content Teams**: Build article layouts, feature sections, and complex content structures visually
- **Design Systems**: Enforce design consistency by using predefined SDC components
- **Agencies**: Rapidly prototype and build client sites with reusable component libraries
- **Developers**: Provide content editors with powerful tools while maintaining control over component structure and styling

## Post-Installation

### Initial Setup

1. **Install the Module**: Enable the SDC Inline Editor module via the Extend page (`/admin/modules`)

2. **Build JavaScript Assets**: The module requires compiled JavaScript assets. Run the build process:
   ```bash
   npm install
   npm run build
   ```

3. **Configure Permissions**: Navigate to People → Permissions (`/admin/people/permissions`) and grant appropriate permissions:
   - **"Use SDC Inline Editor to edit content"** (`sdc_inline_editor.edit_content`): Allows users to use the inline editor
   - **"Administer SDC Inline Editor"** (`sdc_inline_editor.administer`): Allows configuration access

4. **Create or Configure Content Types**: The inline editor works with any content type that has a body field. Ensure your content types have a body field configured.

5. **Create SDC Components**: Build your component library by creating Single Directory Components following Drupal's SDC documentation. Components should be placed in your theme or module's `components/` directory.

6. **Configure Component Attributes**: In your component Twig templates, add SDC editing attributes:
   - Use `{{ sdc_component_attributes(component_name) }}` on the root element
   - Use `{{ sdc_field_attributes('field_name', editable, {'data-sdc-type': 'text-editor'}) }}` for editable fields
   - See `components/SDC_ATTRIBUTES_USAGE.md` for detailed attribute documentation

### Using the Editor

1. **Enable Editing Mode**: When viewing a node with the appropriate permissions, click the "Edit" button in the toolbar to enter editing mode

2. **Add Components**: Click the "+" button in the toolbar to see available components, then drag them onto the page

3. **Edit Content**: Click directly on editable fields (marked with `data-sdc-editable="true"`) to edit inline

4. **Configure Components**: Click a component to open the sidebar where you can edit non-inline properties like image sizes, alignment, and other settings

5. **Rearrange Components**: Drag components to reorder them on the page

6. **Save Changes**: Click the "Publish" button to save your changes

### Important Considerations

- **Content Structure**: All content must be enclosed in an element with `id="sdc-inline-editor-content"` for drag-and-drop to work
- **Component Requirements**: All SDC components must have a single root element
- **Build Process**: Remember to rebuild JavaScript assets (`npm run build`) after updating the module code
- **Component Registry**: The module automatically discovers SDC components in enabled modules and themes

## Additional Requirements

### Drupal Core Requirements

- **Drupal 11.x** (core_version_requirement: ^11)
- **Core Modules**:
  - Field API (`drupal:field`)
  - Image (`drupal:image`)
  - Media (`drupal:media`)
  - Media Library (`drupal:media_library`)
  - Views (`drupal:views`)

### Required Contributed Modules

- **Inline Entity Form** (`inline_entity_form`): ^3.0@RC - Required for entity form integration
- **Entity Browser** (`entity_browser`): ^2.15 - Required for media selection functionality

### JavaScript Dependencies

The module includes bundled JavaScript dependencies managed via npm:
- CKEditor 5 (^46.1.1) - Rich text editing
- CodeMirror 6 (^6.0.1) - HTML code editing
- Various CKEditor plugins and CodeMirror extensions

These are automatically installed when running `npm install`.

### Build Tools

- **Node.js**: Required for building JavaScript assets
- **npm**: Package manager for JavaScript dependencies
- **Webpack**: Bundling tool (included as dev dependency)

## Recommended modules/libraries

While not required, these modules can enhance the SDC Inline Editor experience:

- **Single Directory Components (SDC)**: While SDC is part of Drupal core, ensure you're familiar with creating SDC components
- **Media Library**: Already a dependency, but ensure it's properly configured with your media types
- **Image Styles**: Configure image styles for optimal image display in components
- **Responsive Image**: Use responsive image styles for better performance on mobile devices

## Similar projects

Several Drupal modules provide page building functionality, but SDC Inline Editor has unique characteristics:

- **Layout Builder**: Drupal core's layout builder focuses on block-based layouts with regions. SDC Inline Editor uses component-based architecture with inline editing and stores content as structured SDC components rather than block configurations.

- **Paragraphs**: Paragraphs provides structured content through fieldable entities. SDC Inline Editor uses SDC components (Twig templates) rather than entity-based paragraphs, offering better performance and more flexible theming.

- **Gutenberg**: WordPress-inspired block editor for Drupal. SDC Inline Editor is specifically built for Drupal's SDC system and provides server-side rendering with component-based storage.

- **Entity Browser / Media Library**: These modules handle media selection (and are dependencies), but SDC Inline Editor adds the visual page building layer on top.

**Key Differentiators**:
- Component-based storage (SDC components) vs. entity-based or HTML-based storage
- Server-side rendering for optimal performance
- Inline editing experience with drag-and-drop
- Built specifically for Drupal's Single Directory Components system
- Mixed content support (components + HTML)

## Supporting this Module

Development of SDC Inline Editor is driven by the Drupal community. If you find this module useful and want to support its continued development:

- **Contribute Code**: Submit patches, bug fixes, and feature enhancements via the issue queue
- **Report Issues**: Help improve the module by reporting bugs and suggesting features
- **Write Documentation**: Improve documentation, add examples, and create tutorials
- **Test and Review**: Test new releases and review patches from other contributors
- **Share Feedback**: Let maintainers know how you're using the module and what improvements would help

Visit the [project issue queue](https://www.drupal.org/project/issues/sdc_inline_editor) to get involved.

## Community Documentation

### Official Documentation

- **Drupal.org Project Page**: [https://www.drupal.org/project/sdc_inline_editor](https://www.drupal.org/project/sdc_inline_editor)
- **Issue Queue**: [https://www.drupal.org/project/issues/sdc_inline_editor](https://www.drupal.org/project/issues/sdc_inline_editor)
- **Git Repository**: [https://git.drupalcode.org/project/sdc_inline_editor](https://git.drupalcode.org/project/sdc_inline_editor)

### Related Drupal Documentation

- **Single Directory Components Guide**: [https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components](https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components)
- **SDC Component Usage**: [https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components/using-your-new-single-directory-component](https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components/using-your-new-single-directory-component)

### Module Documentation

- **Component Attributes Usage**: See `components/SDC_ATTRIBUTES_USAGE.md` for Twig helper functions
- **Component Examples**: Review example components in the `components/` directory
- **Contributing Guide**: See `CONTRIBUTING.md` for development guidelines

---

## Additional Information

### Technical Architecture

SDC Inline Editor uses a two-step rendering process:

1. **Validation**: Parses and validates body content for proper SDC component structure, checking component names against the registry and validating properties
2. **Server-Side Rendering**: Converts SDC components into Drupal render arrays and renders them server-side for optimal performance

Content is stored in SDC component format:
```html
<sdc-text-block sdc-data='{"text": "Content here"}'/>
```

Rather than raw HTML, ensuring component consistency and enabling server-side rendering.

### Permissions System

The module includes granular permissions:
- Component-level permissions (edit, delete, move)
- Field-level permissions (text editor, HTML editor, image selector, etc.)
- Toolbar visibility permissions

### API Endpoints

All API endpoints require the `sdc_inline_editor.edit_content` permission:
- `/sdc-inline-editor/api/sdc/component/html` - Get component HTML
- `/sdc-inline-editor/api/sdc/components` - Get accessible components
- `/sdc-inline-editor/api/sdc/component/access` - Check component access

### Custom Routes Integration

The SDC Inline Editor can work on custom routes that display nodes, not just the canonical route. To register a custom route, implement `hook_sdc_inline_editor_routes()`:

```php
/**
 * Implements hook_sdc_inline_editor_routes().
 */
function mymodule_sdc_inline_editor_routes() {
  return [
    'mymodule.custom_node_route',
  ];
}
```

**Important**: Your custom route must have a `node` parameter containing a `NodeInterface` object. See [ROUTE_INTEGRATION.md](ROUTE_INTEGRATION.md) for complete documentation and examples.

### Development

For developers contributing to or extending this module:
- JavaScript source files are in `js/src/`
- PHP services and controllers are in `src/`
- Example components are in `components/`
- Run `npm run watch` during development for automatic rebuilding
