# Drupal.org Module Submission Guidelines

This document outlines the official requirements and guidelines for submitting your module to Drupal.org.

## 📋 Required Files

### 1. LICENSE.txt ✅
- **Status**: ✅ Complete
- **Requirement**: Must contain GPL-2.0+ license text
- **Location**: Root of module directory
- **Note**: Your LICENSE.txt is already in place

### 2. README.md ✅
- **Status**: ✅ Complete (may need enhancements)
- **Required Sections**:
  - Project name and introduction
  - Requirements/Dependencies
  - Installation instructions
  - Configuration guide
  - Usage examples
  - Troubleshooting/FAQ
  - Maintainer information
- **Current Status**: Has basic documentation, consider adding installation steps

### 3. .info.yml File ✅
- **Status**: ✅ Complete
- **Requirements**:
  - Proper module name
  - Description
  - Core version requirement
  - Dependencies listed
  - Version number

### 4. composer.json ✅
- **Status**: ✅ Complete
- **Requirements**:
  - Module name (drupal/module_name format)
  - Type: "drupal-module"
  - License: GPL-2.0-or-later
  - Dependencies listed
  - Support links (update after project creation)

## 🔍 Code Quality Requirements

### 1. Coding Standards
**Status**: ⚠️ Needs Verification

Run these commands to check:
```bash
# Install Drupal Coder
composer require --dev drupal/coder

# Check coding standards
vendor/bin/phpcs --standard=Drupal,DrupalPractice web/modules/custom/sdc_inline_editor

# Auto-fix issues
vendor/bin/phpcbf --standard=Drupal,DrupalPractice web/modules/custom/sdc_inline_editor
```

**Requirements**:
- Follow Drupal coding standards (PSR-12 based)
- Proper indentation (2 spaces)
- Function/class documentation blocks
- No trailing whitespace
- Proper naming conventions

### 2. Security Review
**Status**: ⚠️ Needs Review

**Checklist**:
- [ ] All user inputs are sanitized
- [ ] CSRF tokens on all forms
- [ ] SQL queries use parameterized queries
- [ ] XSS prevention (checkmarkup, t() with placeholders)
- [ ] Access control on all routes/forms
- [ ] File uploads validated
- [ ] No hardcoded credentials

### 3. Documentation
**Status**: ⚠️ Needs Enhancement

**Required**:
- [ ] PHPDoc blocks for all functions/classes
- [ ] Inline comments for complex logic
- [ ] API documentation
- [ ] Hook documentation
- [ ] Service documentation

## 📝 Project Application Requirements

### When Applying at https://www.drupal.org/node/add/project-module

**Required Fields**:

1. **Project Name**: `sdc_inline_editor`
   - Must be lowercase
   - Use underscores, not hyphens
   - Must be unique

2. **Short Description** (150 characters max):
   ```
   Visual drag-and-drop page builder for Drupal using Single Directory Components (SDCs) with inline editing capabilities.
   ```

3. **Full Description**:
   - Use content from README.md
   - Explain what problem it solves
   - List key features
   - Include use cases

4. **License**: GPL-2.0+
   - Must match LICENSE.txt

5. **Development Status**:
   - **Alpha**: Early development, may have bugs
   - **Beta**: Feature complete, testing phase
   - **Stable**: Production ready
   - **Recommendation**: Start with "Beta" or "Alpha"

6. **Maintenance Status**:
   - **Actively maintained**: Regular updates
   - **Seeking co-maintainers**: Looking for help
   - **Minimal maintenance**: Bug fixes only
   - **Under maintenance**: Currently being worked on

7. **Category**: Select appropriate (e.g., "Content", "Content Construction Kit")

## 🧪 Testing Requirements

### Recommended (Not Strictly Required for Initial Submission)

1. **Unit Tests**:
   - Test services and utility functions
   - Location: `tests/src/Unit/`

2. **Kernel Tests**:
   - Test integration with Drupal core
   - Location: `tests/src/Kernel/`

3. **Functional Tests**:
   - Test user-facing functionality
   - Location: `tests/src/Functional/`

**Note**: Tests are highly recommended but not required for initial submission. However, they significantly improve project approval chances.

## 📦 Git Repository Requirements

### After Project Approval

1. **Clone Drupal.org Repository**:
   ```bash
   git clone git@git.drupal.org:project/sdc_inline_editor.git
   ```

2. **Add Your Code**:
   ```bash
   cd sdc_inline_editor
   # Copy your module files here
   git add .
   git commit -m "Initial release"
   git push origin main
   ```

3. **Branch Naming**:
   - `main` or `1.x` for Drupal 11
   - `8.x-1.x` for Drupal 8/9/10 compatibility

## 🚫 Common Rejection Reasons

Avoid these common mistakes:

1. **Missing LICENSE.txt** ✅ (You have this)
2. **Site-specific code** ✅ (You've removed PR references)
3. **Hardcoded paths/URLs** ⚠️ (Check video-embed component)
4. **Missing dependencies in .info.yml** ✅ (You have this)
5. **Poor code quality** ⚠️ (Run PHPCS)
6. **No documentation** ✅ (You have README.md)
7. **Incomplete project description** ⚠️ (Enhance README)
8. **Build artifacts committed** ✅ (Excluded via .gitignore/.gitattributes)

## ✅ Pre-Submission Checklist

Before submitting, verify:

- [x] LICENSE.txt exists with GPL-2.0+
- [x] README.md exists with documentation
- [x] .info.yml has proper metadata
- [x] composer.json exists (optional but recommended)
- [x] .gitignore excludes build artifacts
- [x] .gitattributes configured for packaging
- [ ] Code passes PHPCS checks
- [ ] No site-specific code remains
- [ ] All dependencies are on Drupal.org
- [ ] Security review completed
- [ ] Documentation is comprehensive
- [ ] Project description is clear

## 📚 Official Resources

- **Application Guide**: https://www.drupal.org/docs/develop/managing-a-drupal-org-theme-module-or-distribution-project/applying-for-a-new-project
- **Coding Standards**: https://www.drupal.org/docs/develop/standards
- **Git Workflow**: https://www.drupal.org/docs/develop/git
- **Documentation Guidelines**: https://www.drupal.org/docs/develop/managing-a-drupalorg-theme-module-or-distribution-project/documenting-your-project/module-documentation-guidelines
- **Security Guidelines**: https://www.drupal.org/docs/develop/security

## 🎯 Submission Process Timeline

1. **Prepare Code** (Current step)
   - Fix coding standards
   - Complete documentation
   - Security review

2. **Submit Application**
   - Fill out project application form
   - Wait for review (typically 1-3 days)

3. **Project Approval**
   - Receive GitLab repository access
   - Push code to Drupal.org

4. **Create First Release**
   - Tag version in git
   - Create release node on Drupal.org
   - Add release notes

## 💡 Tips for Success

1. **Start with Beta**: Don't claim "Stable" unless thoroughly tested
2. **Be Responsive**: Respond quickly to reviewer feedback
3. **Document Everything**: Better documentation = faster approval
4. **Test Thoroughly**: Test on clean Drupal installation
5. **Follow Examples**: Look at similar modules for structure
6. **Ask for Help**: Use Drupal.org Slack or forums if stuck

## ⚠️ Special Considerations for Your Module

1. **Build Process**: Document that users need to run `npm install && npm run build`
2. **Submodule**: Decide if `sdc_inline_editor_media` should be separate
3. **RC Dependencies**: Document that `inline_entity_form ^3.0@RC` is required
4. **Component Examples**: Clarify if included components are examples or required

