# Components

This module uses SDC components to ensure an easy, and nice editing experience. The first thing you will need to do is to follow the standard Drupal API documentation on building an SDC. Normally SDC's consist of .twig, .component.yml, .css, and .js files.

## How to build a SDC component that works with this module

Once you have followed the standard Drupal documentation, now you need to ensure the .twig file follows the PR Builder Component standard. A PR Builder Component twig file is made up of the following:

### A root element.

whether it be a div, footer, or header, all PR Builder SDC's must be in a single root parent element. This root element must have the following attributes defined

- data-sdc-component, this allows us to keep track of it in the editing experience. To make this easier to implement, we have provided the following twig utility:
  `{{ sdc_component_attributes(component_name) }}`

The data-sdc-component should only be on the root element of the component, no other elements should have this attribute.

- data-sdc-no-encapsulate, this attribute prevents the component from being wrapped in a `block-wrapper` div with toolbar controls. Use this for components that are nested within other components (like list items) where you don't want individual encapsulation. Simply add `data-sdc-no-encapsulate` to the root element.

### Required fields for child elements

Inside the root element, it is likely you will have content that you want edited inline. The editable elements will need the following attributes:

- data-sdc-field, this is the name of the prop defined in .twig that you want to be able to edit inline.
- data-sdc-editable, this is used to know if a user can edit it or not. We will pass in a variable "editable" if the editing experience is enabled or not
- data-sdc-type, this is the type of the editing experience that you want to enable. The following are types you can choose from:
    - Inline Editors
        - text-editor
        - html-editor
    - Sidebar Editors
        - text-input
        - number-input
        - checkbox-toggle (In the twig, it doesn't work if you default to true, ensure you default to false)
        - image-selector
        - multi-image-selector
- data-sdc-sidebar, this is what tells the front-end if this field should pop up in the sidebar and become editable
- data-nested-container="true", This is what tells the editor that the SDC has nested components. This will normally go on the parent component where you have sdc_component_attributes
- data-drop-container="true" , this is what tells the editor you can drop components into the nested component.
- data-block-wrapper-auto="true", on the parent component makes the block-wrapper in the editing view width auto. Typically used for non-full width components
  In the twig template, in order to make this easier to remember we provide the following utility:
  `{{ sdc_field_attributes('text', editable|default(false), {'data-sdc-type': 'text-editor'}) }}`
  
### Restricting which components can be dropped

If a nested drop zone should only accept specific component types, add the `data-allowed-components` attribute to the element with `data-drop-container="true"`. The value must be a JSON array of fully-qualified component machine names (e.g. `module_name:component_name`).

```twig
<ul
  class="mse-link-list"
  data-drop-container="true"
  data-allowed-components='["mse_sdc_components:link-list-item"]'>
  …
</ul>
```

When present, the PR Builder drag-and-drop logic hides invalid drop targets and blocks drops of disallowed components, whether moving existing blocks or dragging from the toolbar.

### Sidebar field reference

The JavaScript sidebar renders editors based on the `data-sdc-type` you choose. The handlers live in `sdc_inline_editor/js/src/inline-editor/fieldHandlers/sidebar/`. Common types include:

- `text-input`
- `number-input`
- `checkbox-toggle`
- `select-dropdown`
- `image-selector`
- `multi-image-selector`
- `icon-selector` – renders the searchable Font Awesome picker. Make sure your Twig highlights the chosen icon with `data-sdc-icon-preview` so live updates work.

See `components/SDC_ATTRIBUTES_USAGE.md` for helper functions that generate these attributes consistently.

## Thumbnails:

https://www.flaticon.com/search?word=code&weight=bold&type=uicon
