# Flex Row Component

A flexible container component with customizable flexbox properties that allows you to drop and arrange child components. Perfect for creating responsive layouts with precise control over spacing and alignment.

## Features

- **Flex Wrap Control**: Choose how items wrap to new lines
- **Justify Content**: Control horizontal alignment (start, center, end, space-between, space-around, space-evenly)
- **Align Items**: Control vertical alignment (start, center, end, stretch, baseline)
- **Gap Control**: Adjust spacing between items (0-5)
- **Margin Control**: Set top and bottom margins independently
- **Nested Container**: Drop any components inside
- **Bootstrap-Compatible**: Uses Bootstrap utility classes

## Usage

### In the PR Builder Editor

1. Drag the "Flex Row" component from the toolbar
2. Click on the component to open the sidebar editor
3. Configure the following properties:
   - **Flex Wrap**: How items should wrap (Wrap, No Wrap, Wrap Reverse)
   - **Justify Content**: Horizontal alignment
   - **Align Items**: Vertical alignment
   - **Gap Size**: Space between items (0-5)
   - **Bottom Margin**: Margin below the container
   - **Top Margin**: Margin above the container
4. Drag and drop other components (like Card Block) into the flex row

### Example Use Cases

#### Card Grid
```
Flex Row
├── flex_wrap: wrap
├── justify_content: center
├── gap: 5
├── Children:
    ├── Card Block 1
    ├── Card Block 2
    ├── Card Block 3
    └── Card Block 4
```

#### Centered Content Row
```
Flex Row
├── flex_wrap: nowrap
├── justify_content: center
├── align_items: center
└── Children: (any components)
```

#### Space-Between Layout
```
Flex Row
├── flex_wrap: wrap
├── justify_content: space-between
├── gap: 3
└── Children: (any components)
```

## Properties

### Flex Wrap
- **wrap**: Items wrap to new lines (default)
- **nowrap**: Items stay on one line
- **wrap-reverse**: Items wrap in reverse order

### Justify Content
- **start**: Items align to the start
- **center**: Items are centered (default)
- **end**: Items align to the end
- **space-between**: Items spaced evenly with first/last at edges
- **space-around**: Items spaced evenly with equal space around
- **space-evenly**: Items spaced with equal space between

### Align Items
- **start**: Items align to the top
- **center**: Items are vertically centered
- **end**: Items align to the bottom
- **stretch**: Items stretch to fill container (default)
- **baseline**: Items align to their baselines

### Gap Size
- **0**: No gap
- **1**: 0.25rem (4px)
- **2**: 0.5rem (8px)
- **3**: 1rem (16px)
- **4**: 1.5rem (24px)
- **5**: 3rem (48px) - default

### Margin Bottom
- **mb-0**: No bottom margin
- **mb-1**: 0.25rem
- **mb-2**: 0.5rem
- **mb-3**: 1rem
- **mb-4**: 1.5rem
- **mb-5**: 3rem
- **mb-sm-5**: 3rem on small screens, 0 on larger screens (default)

### Margin Top
- **mt-0**: No top margin (default)
- **mt-1**: 0.25rem
- **mt-2**: 0.5rem
- **mt-3**: 1rem
- **mt-4**: 1.5rem
- **mt-5**: 3rem

## Example HTML Output

```html
<div data-sdc-component="sdc_inline_editor:flex-row" 
     data-nested-container="true"
     class="d-flex flex-wrap gap-5 justify-content-center align-items-stretch mb-sm-5 mt-0">
  <div data-drop-container="true" class="flex-row-container" style="display: contents;">
    <!-- Child components render here -->
  </div>
</div>
```

## Comparison with Row Block

### Flex Row
- Single container for all items
- Items flow naturally based on available space
- Uses gap for spacing (modern CSS)
- Perfect for card grids and dynamic layouts
- Items can have different widths

### Row Block
- Defined columns (1-4)
- Items are in separate columns
- Column widths can be customized
- Perfect for structured layouts
- Each column is a distinct container

## Responsive Behavior

The flex row is responsive by default:
- Items will wrap to new lines on smaller screens if `flex-wrap: wrap` is set
- Gap and margin values are consistent across breakpoints
- Use `mb-sm-5` for responsive bottom margins

## Best Practices

1. **Card Layouts**: Use `gap-5` with `justify-content-center` and `flex-wrap: wrap`
2. **Button Rows**: Use `gap-3` with `justify-content-start` and `flex-wrap: nowrap`
3. **Image Galleries**: Use `gap-2` with `justify-content-space-evenly` and `flex-wrap: wrap`
4. **Center Content**: Use `justify-content-center` with `align-items-center`

## Styling

The component uses Bootstrap-compatible utility classes that are defined in `flex-row.css`. If your site already includes Bootstrap, you may see some style overlap, but the component's CSS uses `!important` to ensure consistency.

## Accessibility

- Semantic HTML structure
- No accessibility barriers
- Works with keyboard navigation
- Child components maintain their own accessibility features

## Browser Support

- All modern browsers (Chrome, Firefox, Safari, Edge)
- CSS Flexbox required
- CSS Gap property supported in all modern browsers

