# Hero Image Component

A full-page hero image component with title and subtitle overlaid directly on the image.

## Features

- **Full Viewport Coverage**: The hero image spans the entire width and height of the page
- **Text Overlay**: Title and subtitle are overlaid directly on the image
- **Title & Subtitle**: Prominent heading with supporting tagline text
- **Customizable Overlay**: Adjust image darkness (none, light, medium, dark)
- **Text Color Options**: Choose white or black text to contrast with your image
- **Responsive Design**: Adapts beautifully to all screen sizes
- **Smooth Animations**: Subtle slide-in effects for visual polish
- **Accessibility**: Fully keyboard navigable with proper semantic HTML

## Properties

| Property | Type | Default | Description |
|----------|------|---------|-------------|
| `drupalMediaUuid` | string | '' | The hero image to display |
| `title` | string | '' | Main heading text |
| `subtitle` | string | '' | Subtitle or tagline text |
| `overlayOpacity` | string | 'medium' | Darkness overlay (none/light/medium/dark) |
| `textColor` | string | 'white' | Text color (white/black) |
| `height` | string | 'full' | Hero section height (full/half) |

## Usage

1. Add the component to your page
2. Upload a high-quality, full-resolution image
3. Enter a compelling title and subtitle
4. Adjust overlay settings to match your design
5. Choose text color that provides good contrast with your image

## Design Tips

- Use high-resolution images (at least 1920x1080)
- Keep titles concise and impactful (3-8 words)
- Subtitles should provide context (10-20 words)
- Adjust overlay opacity to ensure text readability
- Test on mobile devices to ensure text remains legible

## Browser Support

Works in all modern browsers with graceful degradation for older browsers.

