/**
 * @file
 * Hero Image Component JavaScript
 */

(function () {
  'use strict';

  // Initialize hero images
  Drupal.behaviors.heroImage = {
    attach: function (context, settings) {
      const heroImages = context.querySelectorAll('.hero-image-wrapper');
      
      heroImages.forEach(function (heroImage) {
        // Check if already initialized
        if (heroImage.classList.contains('hero-image-initialized')) {
          return;
        }
        
        heroImage.classList.add('hero-image-initialized');
        
        // Initialize scroll animations
        initScrollAnimations(heroImage);
      });
    }
  };
  
  /**
   * Initialize scroll animations for hero image
   */
  function initScrollAnimations(heroImage) {
    const background = heroImage.querySelector('.hero-image-bg');
    const title = heroImage.querySelector('.hero-title');
    const subtitle = heroImage.querySelector('.hero-subtitle');
    const date = heroImage.querySelector('.hero-date');
    
    // Create an Intersection Observer to watch for when hero enters the viewport
    const observerOptions = {
      root: null, // Use viewport as root
      rootMargin: '0px', // Trigger when element enters viewport
      threshold: 0.1 // Trigger when 10% of element is visible
    };
    
    const observer = new IntersectionObserver(function(entries) {
      entries.forEach(function(entry) {
        if (entry.isIntersecting) {
          // Animate background image
          if (background) {
            background.classList.add('animate-in');
          }
          
          // Animate title (with delay handled by CSS)
          if (title) {
            title.classList.add('animate-in');
          }
          
          // Animate subtitle (with delay handled by CSS)
          if (subtitle) {
            subtitle.classList.add('animate-in');
          }
          
          // Animate date (with delay handled by CSS)
          if (date) {
            date.classList.add('animate-in');
          }
          
          // Stop observing once animated
          observer.unobserve(entry.target);
        }
      });
    }, observerOptions);
    
    // Observe the hero image
    observer.observe(heroImage);
  }

})();

