# Row Block Component

A flexible row container component that allows content creators to build multi-column layouts with drag-and-drop functionality.

## Features

- **Multiple Column Layouts**: Choose from 6 different column configurations
- **Responsive Design**: Automatically adapts to mobile and tablet screens
- **Drag and Drop**: Drop any component into any column
- **Visual Feedback**: Clear drop zones and hover states during editing
- **Nested Components**: Properly saves nested component structure

## Available Layouts

1. **1 Column (Full Width)** - `1-col`
   - Single full-width column
   
2. **2 Columns (Equal)** - `2-col-equal`
   - Two columns of equal width (50% / 50%)
   
3. **2 Columns (2/3 - 1/3)** - `2-col-left`
   - Left column takes 2/3, right column takes 1/3
   
4. **2 Columns (1/3 - 2/3)** - `2-col-right`
   - Left column takes 1/3, right column takes 2/3
   
5. **3 Columns (Equal)** - `3-col-equal`
   - Three columns of equal width (33% / 33% / 33%)
   
6. **4 Columns (Equal)** - `4-col-equal`
   - Four columns of equal width (25% / 25% / 25% / 25%)

## Usage

### Adding a Row Component

1. In editing mode, drag the "Row" component from the toolbar
2. Drop it where you want to place the row
3. The row will appear with the default layout (2 equal columns)

### Changing the Layout

1. Click the settings icon (gear) on the row component
2. In the sidebar, select "Column Layout"
3. Choose your desired layout from the dropdown
4. Click "Save" to apply the changes

### Adjusting Column Widths Dynamically

You can customize column widths beyond the preset layouts:

1. **Find the resize handle**: Look for the vertical bar between columns (appears as a thin line)
2. **Hover over the handle**: The cursor changes to a resize cursor (↔)
3. **Drag to resize**: Click and drag left or right to adjust column widths
4. **Release**: Widths are automatically saved
5. **Visual feedback**: The handle highlights blue while hovering/dragging

**Notes:**
- Minimum column width is 10% to prevent columns from becoming too small
- Resize handles only appear in editing mode
- Custom widths are saved and persist across page loads
- On mobile, custom widths are ignored (columns stack automatically)
- You can resize any adjacent column pair independently

### Adding Components to Columns

1. Drag any component from the toolbar
2. Hover over a column in the row - it will highlight
3. Drop the component into the column
4. You can add multiple components to each column
5. Components can be reordered within and between columns

### Moving Components

- **Within a column**: Drag the move icon to reorder components
- **Between columns**: Drag a component from one column to another
- **Out of a row**: Drag a component out of the row to the main content area

## Responsive Behavior

### Desktop (> 992px)
- All layouts display as configured

### Tablet (768px - 992px)
- 4-column layouts become 2x2 grid
- 2/3 - 1/3 layouts become equal columns
- Other layouts remain the same

### Mobile (< 768px)
- All multi-column layouts stack into a single column
- Components display in order from left to right, top to bottom

## Data Structure

When saved, the row component stores:

```json
{
  "componentType": "sdc_inline_editor:row-block",
  "fields": {
    "layout": {
      "type": "select-dropdown",
      "value": "2-col-equal"
    },
    "widths": {
      "type": "custom-widths",
      "value": [45.5, 54.5]
    },
    "children": {
      "type": "nested-components",
      "value": [
        {
          "columnIndex": 0,
          "components": [
            // Array of components in column 1
          ]
        },
        {
          "columnIndex": 1,
          "components": [
            // Array of components in column 2
          ]
        }
      ]
    }
  }
}
```

**Field Descriptions:**
- `layout`: The base layout template (e.g., "2-col-equal")
- `widths`: Custom column widths as percentages (empty array means use default layout)
- `children`: Nested components organized by column index

## Technical Details

### Files

- `row-block.component.yml` - Component definition and props schema
- `row-block.twig` - Template for rendering the row and columns
- `row-block.css` - Styles including responsive breakpoints
- `row-block.js` - JavaScript for drag-and-drop handling

### Attributes

The row component uses several data attributes:

- `data-nested-container="true"` - Identifies the component as a row container
- `data-drop-container="true"` - Marks columns as valid drop targets
- `data-column-index` - Tracks column position for saving
- `data-custom-widths` - Stores custom column widths as JSON array
- `data-left-column` / `data-right-column` - Identifies which columns a resize handle affects

### Integration

The row component integrates with:

- **DragAndDrop.js** - Enhanced to recognize row columns as drop zones
- **DataProcessor.js** - Modified to save nested component structure
- **Editor.js** - Encapsulates nested components properly

## Styling

You can customize the row component by modifying `row-block.css`:

- Column spacing: `.row-column { margin: 0 12px; }`
- Column backgrounds: `.row-column { background: ... }`
- Resize handle appearance: `.resize-handle-bar { background: #ccc; }`
- Resize handle hover color: `.row-resize-handle:hover .resize-handle-bar { background: #007cba; }`
- Responsive breakpoints: `@media (max-width: ...)`

## Best Practices

1. **Don't nest rows too deep**: While rows can contain any component, deeply nested rows can make layouts complex
2. **Consider mobile**: Always preview how your multi-column layout appears on mobile (custom widths are ignored on mobile)
3. **Use appropriate layouts**: Start with preset layouts, then fine-tune with resize handles if needed
4. **Test responsiveness**: Check that your content works well when columns stack
5. **Minimum widths**: Don't make columns too narrow - keep them at least 20% for readability
6. **Reset widths**: Change the layout in settings to reset custom widths back to defaults

## Troubleshooting

### Components won't drop into columns
- Ensure editing mode is active
- Check that columns have `data-drop-container="true"` attribute
- Verify drag-and-drop manager is initialized

### Layout changes don't save
- Ensure you click "Save" in the sidebar after changing the layout
- Check browser console for any JavaScript errors

### Nested components don't save
- Verify that DataProcessor is properly processing nested components
- Check that the row has `data-nested-container="true"` attribute

### Custom widths don't persist
- Ensure the widths field has `data-sdc-type="custom-widths"` attribute
- Check that the JavaScript is updating `data-sdc-prop-custom-widths` after resizing
- Verify browser console for any JavaScript errors during resize

### Resize handles don't appear
- Confirm you're in editing mode
- Check that the row has more than one column
- Verify the CSS for `.row-resize-handle` is loaded
- Look for JavaScript errors in browser console

