/**
 * @file
 * Text Block Component JavaScript
 */

(function () {
  'use strict';

  // Initialize text blocks
  Drupal.behaviors.textBlock = {
    attach: function (context, settings) {
      const textBlocks = context.querySelectorAll('.text-wrapper.animated');
      
      textBlocks.forEach(function (textBlock) {
        // Check if already initialized
        if (textBlock.classList.contains('text-block-initialized')) {
          return;
        }
        
        textBlock.classList.add('text-block-initialized');
        
        // Initialize scroll animations
        initScrollAnimation(textBlock);
      });
    }
  };
  
  /**
   * Initialize scroll animation for text block
   */
  function initScrollAnimation(textBlock) {
    // Create an Intersection Observer to watch for when text block enters the viewport
    const observerOptions = {
      root: null, // Use viewport as root
      rootMargin: '0px 0px -100px 0px', // Trigger slightly before element enters viewport
      threshold: 0.1 // Trigger when 10% of element is visible
    };
    
    const observer = new IntersectionObserver(function(entries) {
      entries.forEach(function(entry) {
        if (entry.isIntersecting) {
          // Add animation class
          entry.target.classList.add('animate-in');
          
          // Stop observing once animated
          observer.unobserve(entry.target);
        }
      });
    }, observerOptions);
    
    // Observe the text block
    observer.observe(textBlock);
  }

})();

