import {
    InlineEditor,
    ClassicEditor,
    Essentials,
    Autoformat,
    Bold,
    Italic,
    BlockQuote,
    Heading,
    Indent,
    Link,
    List,
    Paragraph,
    TextTransformation,
    GeneralHtmlSupport,
    ClipboardPipeline,
	Alignment
} from 'ckeditor5';

import HtmlCodeMirrorPlugin from './plugins/htmlCodeMirrorPlugin';

import 'ckeditor5/dist/ckeditor5.css';

class TextEditor extends InlineEditor {
	static builtinPlugins = [
		Essentials,
		Autoformat,
		Bold,
		Italic,
		BlockQuote,
		Heading,
		Indent,
		Link,
		List,
		Paragraph,
		TextTransformation,
		ClipboardPipeline,
		Alignment,
	];

	static defaultConfig = {
        licenseKey: 'GPL',
		toolbar: {
			items: [
				'undo',
				'redo',
				'|',
				'heading',
				'|',
				'bold',
				'italic',
				'|',
				'link',
				'blockQuote',
				'|',
				'bulletedList',
				'numberedList',
				'outdent',
				'indent',
				'|',
				'alignment',
			],
		},
		table: {
			contentToolbar: ['tableColumn', 'tableRow', 'mergeTableCells'],
		},
		language: 'en',
		clipboard: {
			filterData: (dataTransfer, editor) => {
				// Get the HTML content from clipboard
				const htmlData = dataTransfer.getData('text/html');
				
				if (htmlData) {
					// Create a temporary DOM element to parse the HTML
					const tempDiv = document.createElement('div');
					tempDiv.innerHTML = htmlData;
					
					// Remove all elements except allowed ones
					const allowedTags = ['p', 'br', 'strong', 'b', 'em', 'i', 'ul', 'ol', 'li', 'a'];
					const allowedAttributes = ['href']; // Only allow href for links
					
					// Function to clean elements recursively
					const cleanElement = (element) => {
						if (element.nodeType === Node.ELEMENT_NODE) {
							// If element is not in allowed tags, replace with text content
							if (!allowedTags.includes(element.tagName.toLowerCase())) {
								const textNode = document.createTextNode(element.textContent);
								element.parentNode.replaceChild(textNode, element);
								return;
							}
							
							// Remove all attributes except allowed ones
							const attributes = Array.from(element.attributes);
							attributes.forEach(attr => {
								if (!allowedAttributes.includes(attr.name)) {
									element.removeAttribute(attr.name);
								}
							});
							
							// Clean child elements
							const children = Array.from(element.childNodes);
							children.forEach(child => cleanElement(child));
						}
					};
					
					// Clean all elements in the temp div
					const children = Array.from(tempDiv.childNodes);
					children.forEach(child => cleanElement(child));
					
					// Update the clipboard data with cleaned HTML
					dataTransfer.setData('text/html', tempDiv.innerHTML);
				}
			}
		}
	};
}

// ClassicEditor for sidebar use - has a fixed toolbar at the top
class SidebarTextEditor extends ClassicEditor {
	static builtinPlugins = [
		Essentials,
		Autoformat,
		Bold,
		Italic,
		BlockQuote,
		Heading,
		Indent,
		Link,
		List,
		Paragraph,
		TextTransformation,
		ClipboardPipeline,
		Alignment,
	];

	static defaultConfig = {
        licenseKey: 'GPL',
		toolbar: {
			items: [
				'undo',
				'redo',
				'|',
				'heading',
				'|',
				'bold',
				'italic',
				'|',
				'link',
				'blockQuote',
				'|',
				'bulletedList',
				'numberedList',
				'outdent',
				'indent',
				'|',
				'alignment',
			],
			shouldNotGroupWhenFull: true
		},
		language: 'en',
		clipboard: {
			filterData: (dataTransfer, editor) => {
				// Get the HTML content from clipboard
				const htmlData = dataTransfer.getData('text/html');
				
				if (htmlData) {
					// Create a temporary DOM element to parse the HTML
					const tempDiv = document.createElement('div');
					tempDiv.innerHTML = htmlData;
					
					// Remove all elements except allowed ones
					const allowedTags = ['p', 'br', 'strong', 'b', 'em', 'i', 'ul', 'ol', 'li', 'a'];
					const allowedAttributes = ['href']; // Only allow href for links
					
					// Function to clean elements recursively
					const cleanElement = (element) => {
						if (element.nodeType === Node.ELEMENT_NODE) {
							// If element is not in allowed tags, replace with text content
							if (!allowedTags.includes(element.tagName.toLowerCase())) {
								const textNode = document.createTextNode(element.textContent);
								element.parentNode.replaceChild(textNode, element);
								return;
							}
							
							// Remove all attributes except allowed ones
							const attributes = Array.from(element.attributes);
							attributes.forEach(attr => {
								if (!allowedAttributes.includes(attr.name)) {
									element.removeAttribute(attr.name);
								}
							});
							
							// Clean child elements
							const children = Array.from(element.childNodes);
							children.forEach(child => cleanElement(child));
						}
					};
					
					// Clean all elements in the temp div
					const children = Array.from(tempDiv.childNodes);
					children.forEach(child => cleanElement(child));
					
					// Update the clipboard data with cleaned HTML
					dataTransfer.setData('text/html', tempDiv.innerHTML);
				}
			}
		}
	};
}


export { TextEditor, SidebarTextEditor };
