const handleImageCrop = (element) => {
	const cropData = element.getAttribute('data-sdc-prop-image-crop') || '';
	
	if (cropData && cropData !== '{}' && cropData !== '') {
		try {
			const parsed = JSON.parse(cropData);
			
			// Only return if it has actual crop data
			if (parsed && Object.keys(parsed).length > 0) {
				return parsed;
			}
		} catch (e) {
			console.warn('Failed to parse image-crop data:', cropData);
		}
	}
	return {};
};

export default handleImageCrop;
