/**
 * Data Field Handler for Link List Manager
 * Returns the parsed JSON array of link items
 */

const handleLinkListManager = (element) => {
	const value = element.getAttribute('data-sdc-prop-link-list-manager') || '[]';
	
	try {
		const items = JSON.parse(value);
		// Return the array directly - it will be passed as link_list_items prop
		return Array.isArray(items) ? items : [];
	} catch (e) {
		console.warn('Failed to parse link-list-manager data:', e);
		return [];
	}
};

export default handleLinkListManager;

