const handleTextEditor = (element) => {
	// For sidebar editors, the value is stored in the data attribute
	// For inline editors, it's in the innerHTML
	if (element.hasAttribute('data-sdc-sidebar') && element.getAttribute('data-sdc-sidebar') === 'true') {
		const encodedValue = element.getAttribute('data-sdc-prop-text-editor') || '';
		
		// Decode HTML entities (e.g., &lt;ul&gt; becomes <ul>)
		const textarea = document.createElement('textarea');
		textarea.innerHTML = encodedValue;
		return textarea.value;
	}
	
	// For inline editors, try to get data from CKEditor instance if available
	// This ensures HTML entities are properly preserved
	if (element.id && window.ckEditor5Manager) {
		const editor = window.ckEditor5Manager.getEditor(element.id);
		if (editor && typeof editor.getData === 'function') {
			return editor.getData();
		}
	}
	
	// Fallback: For inline editors, read from innerHTML
	// innerHTML returns the actual HTML content (not HTML entities)
	// So we can return it directly - it will be properly encoded when saved to JSON
	return element.innerHTML;
};

export default handleTextEditor;


