import handleCheckboxToggle from './data/checkboxToggle.js';
import handleColorPicker from './data/colorPicker.js';
import handleCustomWidths from './data/customWidths.js';
import handleDateTable from './data/dateTable.js';
import handleHtmlEditor from './data/htmlEditor.js';
import handleIconSelector from './data/iconSelector.js';
import handleImageAlignment from './data/imageAlignment.js';
import handleImageCrop from './data/imageCrop.js';
import handleImageSelector from './data/imageSelector.js';
import handleLinkListManager from './data/linkListManager.js';
import handleMultiImageSelector from './data/multiImageSelector.js';
import handleNestedComponents from './data/nestedComponents.js';
import handleNumberInput from './data/numberInput.js';
import handleSelectDropdown from './data/selectDropdown.js';
import handleTextEditor from './data/textEditor.js';
import handleTextInput from './data/textInput.js';
import handleTextarea from './data/textarea.js';
import defaultDataFieldHandler from './data/defaultHandler.js';

export const dataFieldHandlers = {
	'html-editor': handleHtmlEditor,
	'text-editor': handleTextEditor,
	'text-editor-popup': handleTextEditor,
	'text-input': handleTextInput,
	'textarea': handleTextarea,
	'date-table': handleDateTable,
	'image-selector': handleImageSelector,
	'image-crop': handleImageCrop,
	'image-alignment': handleImageAlignment,
	'color-picker': handleColorPicker,
	'select-dropdown': handleSelectDropdown,
	'icon-selector': handleIconSelector,
	'number-input': handleNumberInput,
	'checkbox-toggle': handleCheckboxToggle,
	'multi-image-selector': handleMultiImageSelector,
	'nested-components': handleNestedComponents,
	'custom-widths': handleCustomWidths,
	'link-list-manager': handleLinkListManager,
};

export { defaultDataFieldHandler };


