const createCheckboxToggle = (sidebar, fieldName, originalElement) => {
	const label = document.createElement('label');
	label.className = 'sidebar-checkbox-toggle';

	const input = document.createElement('input');
	input.type = 'checkbox';
	input.checked = sidebar.getFieldValue(originalElement, 'checkbox-toggle');

	const span = document.createElement('span');
	span.textContent = sidebar.getFieldLabel(fieldName);

	input.addEventListener('change', (event) => {
		sidebar.updateFieldValue(originalElement, event.target.checked, 'checkbox-toggle');
	});

	label.appendChild(input);
	label.appendChild(span);

	return label;
};

export default createCheckboxToggle;


