const createColorPicker = (sidebar, fieldName, originalElement) => {
	const input = document.createElement('input');
	input.type = 'color';
	input.className = 'sidebar-color-picker';
	input.value = sidebar.getFieldValue(originalElement, 'color-picker') || '#000000';

	input.addEventListener('change', (event) => {
		sidebar.updateFieldValue(originalElement, event.target.value, 'color-picker');
		sidebar.updateColorProperty(sidebar.currentComponent, fieldName, event.target.value);
	});

	return input;
};

export default createColorPicker;


