const createImageAlignment = (sidebar, fieldName, originalElement) => {
	const select = document.createElement('select');
	select.className = 'sidebar-alignment-select';
	select.innerHTML = `
      <option value="left">Left</option>
      <option value="right">Right</option>
      <option value="center">Center</option>
      <option value="none">None</option>
    `;

	const currentValue = sidebar.getFieldValue(originalElement, 'image-alignment') || 'left';
	select.value = currentValue;

	select.addEventListener('change', (event) => {
		sidebar.updateFieldValue(originalElement, event.target.value, 'image-alignment');
		sidebar.updateImageAlignment(sidebar.currentComponent, event.target.value);
	});

	return select;
};

export default createImageAlignment;


