const createNumberInput = (sidebar, fieldName, originalElement) => {
	const input = document.createElement('input');
	input.type = 'number';
	input.className = 'sidebar-number-input';
	input.value = sidebar.getFieldValue(originalElement, 'number-input') || 0;

	const min = originalElement.getAttribute('data-sdc-min');
	const max = originalElement.getAttribute('data-sdc-max');
	if (min) input.min = parseFloat(min);
	if (max) input.max = parseFloat(max);

	input.addEventListener('input', (event) => {
		sidebar.updateFieldValue(originalElement, parseFloat(event.target.value), 'number-input');
	});

	return input;
};

export default createNumberInput;


