const createSelectDropdown = (sidebar, fieldName, originalElement) => {
	const select = document.createElement('select');
	select.className = 'sidebar-select-dropdown';

	const options = sidebar.getDropdownOptions(originalElement) || ['option1', 'option2', 'option3'];

	options.forEach((option) => {
		const optionElement = document.createElement('option');

		if (typeof option === 'object' && option !== null) {
			optionElement.value = option.value || option.id || '';
			optionElement.textContent = option.label || option.title || option.value || option.id || '';
		} else {
			optionElement.value = option;
			optionElement.textContent = option;
		}

		select.appendChild(optionElement);
	});

	const currentValue = sidebar.getFieldValue(originalElement, 'select-dropdown');
	if (currentValue) {
		select.value = currentValue;
	}

	select.addEventListener('change', (event) => {
		sidebar.updateFieldValue(originalElement, event.target.value, 'select-dropdown');
	});

	return select;
};

export default createSelectDropdown;


