import { SidebarTextEditor } from '../../../ckeditor5/ckeditor5-config';

const createTextEditor = (sidebar, fieldName, originalElement) => {
	// Create a container div for the CKEditor
	const container = document.createElement('div');
	container.className = 'sidebar-text-editor';
	
	// Create the editable div that CKEditor will replace
	const editorDiv = document.createElement('div');
	editorDiv.className = 'sidebar-text-editor-content';
	
	// Get initial value from the field
	const initialValue = sidebar.getFieldValue(originalElement, 'text-editor') || '';
	editorDiv.innerHTML = initialValue;
	
	container.appendChild(editorDiv);
	
	// Initialize CKEditor asynchronously using ClassicEditor (has fixed toolbar)
	let editorInstance = null;
	
	SidebarTextEditor.create(editorDiv, {
		// ClassicEditor config - toolbar will be visible at the top
	})
		.then(editor => {
			editorInstance = editor;
			
			// Listen for changes and update the field value
			editor.model.document.on('change:data', () => {
				const content = editor.getData();
				sidebar.updateFieldValue(originalElement, content, 'text-editor');
			});
			
			// Store editor instance on the container for cleanup
			container._editorInstance = editor;
		})
		.catch(error => {
			console.error('Failed to initialize CKEditor in sidebar:', error);
		});
	
	// Add cleanup method
	container._destroy = () => {
		if (container._editorInstance) {
			container._editorInstance.destroy()
				.catch(error => {
					console.error('Failed to destroy CKEditor:', error);
				});
		}
	};
	
	return container;
};

export default createTextEditor;
