const createTextInput = (sidebar, fieldName, originalElement) => {
	const input = document.createElement('input');
	input.type = 'text';
	input.className = 'sidebar-text-input';
	input.value = sidebar.getFieldValue(originalElement, 'text-input') || '';

	input.addEventListener('input', (event) => {
		sidebar.updateFieldValue(originalElement, event.target.value, 'text-input');
	});

	return input;
};

export default createTextInput;


