const createTextarea = (sidebar, fieldName, originalElement) => {
	const textarea = document.createElement('textarea');
	textarea.className = 'sidebar-textarea';
	textarea.rows = 10;
	textarea.value = sidebar.getFieldValue(originalElement, 'textarea') || '';

	textarea.addEventListener('input', (event) => {
		sidebar.updateFieldValue(originalElement, event.target.value, 'textarea');
	});

	return textarea;
};

export default createTextarea;
