import createCheckboxToggle from './sidebar/checkboxToggle.js';
import createColorPicker from './sidebar/colorPicker.js';
import createDateTable from './sidebar/dateTable.js';
import createIconSelector from './sidebar/iconSelector.js';
import createImageAlignment from './sidebar/imageAlignment.js';
import createImageSelector from './sidebar/imageSelector.js';
import createLinkListManager from './sidebar/linkListManager.js';
import createMultiImageSelector from './sidebar/multiImageSelector.js';
import createNumberInput from './sidebar/numberInput.js';
import createSelectDropdown from './sidebar/selectDropdown.js';
import createTextInput from './sidebar/textInput.js';
import createTextarea from './sidebar/textarea.js';
import createTextEditor from './sidebar/textEditor.js';

export const sidebarFieldHandlers = {
	'text-input': createTextInput,
	'textarea': createTextarea,
	'text-editor': createTextEditor,
	'date-table': createDateTable,
	'image-selector': createImageSelector,
	'multi-image-selector': createMultiImageSelector,
	'image-alignment': createImageAlignment,
	'color-picker': createColorPicker,
	'select-dropdown': createSelectDropdown,
	'number-input': createNumberInput,
	'checkbox-toggle': createCheckboxToggle,
	'icon-selector': createIconSelector,
	'link-list-manager': createLinkListManager,
	default: createTextInput,
};

