import { Editor } from './inline-editor';

(function ($, Drupal, drupalSettings) {
	Drupal.behaviors.sdcInlineEditor = {
		/**
		 * Initialize the SDC Inline Editor with available SDC components.
		 * @param {*} context
		 * @param {*} settings
		 */
		attach: function (context, settings) {
			// Prevent re-initialization if editor already exists
			// This is critical because Drupal.attachBehaviors() is called multiple times
			// and we don't want to create duplicate Editor instances
			if (window.editor) {
				return;
			}

			// Get component names from drupalSettings
			const sdcInlineEditorSettings = settings.sdcInlineEditor || {};
			const availableComponents = sdcInlineEditorSettings.components || [];
			const editingMode = sdcInlineEditorSettings.editingMode || false;
			const enabled = sdcInlineEditorSettings.enabled || false;
			const nodeId = sdcInlineEditorSettings.nodeId || null;

			// Permission settings
			const hasShowToolbarPermission = sdcInlineEditorSettings.has_show_toolbar_permission || false;
			const hasDeletePermission = sdcInlineEditorSettings.has_delete_permission || false;
			const hasMovePermission = sdcInlineEditorSettings.has_move_permission || false;

			// Permission settings for field-level sidebar and content editing
			const hasEditTextEditorFieldPermission = sdcInlineEditorSettings.has_edit_text_editor_field_permission || false;
			const hasEditHtmlEditorFieldPermission = sdcInlineEditorSettings.has_edit_html_editor_field_permission || false;
			const hasEditImageSelectorFieldPermission = sdcInlineEditorSettings.has_edit_image_selector_field_permission || false;
			const hasEditNumberInputFieldPermission = sdcInlineEditorSettings.has_edit_number_input_field_permission || false;
			const hasEditCheckboxInputFieldPermission = sdcInlineEditorSettings.has_edit_checkbox_input_field_permission || false;
			const hasEditSelectDropdownFieldPermission = sdcInlineEditorSettings.has_edit_select_dropdown_field_permission || false;
			const hasEditMultiImageSelectorFieldPermission = sdcInlineEditorSettings.has_edit_multi_image_selector_field_permission || false;
			const hasEditTextInputFieldPermission = sdcInlineEditorSettings.has_edit_text_input_field_permission || false;
			const hasEditIconSelectorFieldPermission = sdcInlineEditorSettings.has_edit_icon_selector_field_permission || false;

			// Only initialize the editor if SDC Inline Editor is enabled and in editing mode
			if (enabled && editingMode && nodeId) {
				// Initialize the editor with component information and node ID
				window.editor = new Editor({
					components: availableComponents,
					editingMode: editingMode,
					nodeId: nodeId,
					hasDeletePermission: hasDeletePermission,
					hasMovePermission: hasMovePermission,
					hasShowToolbarPermission: hasShowToolbarPermission,
					hasEditTextEditorFieldPermission: hasEditTextEditorFieldPermission,
					hasEditHtmlEditorFieldPermission: hasEditHtmlEditorFieldPermission,
					hasEditImageSelectorFieldPermission: hasEditImageSelectorFieldPermission,
					hasEditNumberInputFieldPermission: hasEditNumberInputFieldPermission,
					hasEditCheckboxInputFieldPermission: hasEditCheckboxInputFieldPermission,
					hasEditSelectDropdownFieldPermission: hasEditSelectDropdownFieldPermission,
					hasEditMultiImageSelectorFieldPermission: hasEditMultiImageSelectorFieldPermission,
					hasEditTextInputFieldPermission: hasEditTextInputFieldPermission,
					hasEditIconSelectorFieldPermission: hasEditIconSelectorFieldPermission,
				});
			}
		},
	};
})(jQuery, Drupal, drupalSettings);
