<?php

namespace Drupal\sdc_inline_editor\Helper;

use Drupal\sdc_inline_editor\Service\SDCService;
use Drupal\Core\Entity\EntityInterface;
use Drupal\node\NodeInterface;

/**
 * Helper class for SDC Inline Editor functionality.
 */
class SdcInlineEditorHelper {

  /**
   * The SDC service.
   *
   * @var \Drupal\sdc_inline_editor\Service\SDCService
   */
  protected $sdcService;

  /**
   * Constructs a SdcInlineEditorHelper object.
   *
   * @param \Drupal\sdc_inline_editor\Service\SDCService $sdc_service
   *   The SDC service.
   */
  public function __construct(SDCService $sdc_service) {
    $this->sdcService = $sdc_service;
  }

  /**
   * Get accessible components for a specific entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to get components for.
   *
   * @return array
   *   Array of accessible component names.
   */
  public function getAccessibleComponentsForEntity(EntityInterface $entity) {
    $content_type = NULL;
    
    if ($entity instanceof NodeInterface) {
      $content_type = $entity->bundle();
    }
    
    return $this->sdcService->getAccessibleComponents($content_type);
  }

  /**
   * Get accessible components for current context.
   *
   * @param string $content_type
   *   The content type machine name.
   *
   * @return array
   *   Array of accessible component names.
   */
  public function getAccessibleComponentsForContentType($content_type) {
    return $this->sdcService->getAccessibleComponents($content_type);
  }

  /**
   * Check if a component is accessible for a content type.
   *
   * @param string $component_name
   *   The component name to check.
   * @param string $content_type
   *   The content type machine name.
   *
   * @return bool
   *   TRUE if component is accessible, FALSE otherwise.
   */
  public function isComponentAccessible($component_name, $content_type = NULL) {
    $accessible_components = $this->sdcService->getAccessibleComponents($content_type);
    return in_array($component_name, $accessible_components);
  }

}

