<?php

namespace Drupal\sdc_inline_editor\Service;
use Drupal\sdc_inline_editor\Component\SDCComponent;
use Drupal\sdc_inline_editor\Component\RawComponent;

/**
 * This service is responsible for building the content after it has been validated.
 * 
 */
class ContentBuilderService {

    /**
     * Build the content from the components.
     * @param array $components
     * @param bool $editing_mode Whether to include editing attributes
     * @return array
     */
    public function buildContent(array $components, bool $editing_mode = false): array
    {
        $renderArray = [];
        foreach ($components as $component) {
            // Add editable prop to the component props before building render array
            if ($component instanceof SDCComponent) {
                $component->props['editable'] = $editing_mode ? TRUE : FALSE;
            }
            
            $componentRenderArray = $component->buildRenderArray();
            
            // Add editing attributes if in editing mode
            if ($editing_mode && $component instanceof SDCComponent) {
                $componentRenderArray['#attributes'] = [
                    'data-sdc-component' => $component->getName(),
                ];
            }
            
            $renderArray[] = $componentRenderArray;
        }
        
        return $renderArray;
    }


}